@extends('layouts.app')

@section('content')
    <section class="section">
        <div class="section-header">
            <h3 class="page__heading">Temporadas</h3>
        </div>
        <div class="section-body">
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <a class="btn btn-warning" href="{{ route('seasons.create') }}">Nueva</a>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-striped table-md">
                                    <tbody>
                                        <tr>
                                            <th>Número</th>
                                            <th>Estado</th>
                                            <th>Acciones</th>
                                        </tr>
                                        @foreach($seasons as $season)
                                        <tr>
                                            <td>{{ $season->number }}</td>
                                            <td>
                                                @if ($season->status == 1)
                                                    Habilitado
                                                @else
                                                    Deshabilitado
                                                @endif
                                            </td>
                                            <td>
                                                <a class="btn btn-info" href="{{ route('seasons.edit', $season->id) }}">Editar</a>
{{--                                                {!! Form::open(['method' => 'DELETE', 'route' => ['seasons.destroy', $season->id], 'style' => 'display:inline']) !!}--}}
{{--                                                {!! Form::submit('Eliminar', ['class' => 'btn btn-danger']) !!}--}}
{{--                                                {!! Form::close() !!}--}}
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="pagination justify-content-end">
                                {!! $seasons->links() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

