@extends('layouts.app')

@section('content')
    <section class="section">
        <div class="section-header">
            <h3 class="page__heading">Episodios</h3>
        </div>
        <div class="section-body">
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <a class="btn btn-warning" href="{{ route('episodes.create') }}">Nuevo</a>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-striped table-md">
                                    <tbody>
                                        <tr>
                                            <th>Título</th>
                                            <th>Link Vimeo</th>
                                            <th>Temporada</th>
                                            <th>Estado</th>
                                            <th>En Home</th>
                                            <th>Acciones</th>
                                        </tr>
                                        @foreach($episodes as $episode)
                                        <tr>
                                            <td>{{ $episode->title }}</td>
                                            <td>{{ $episode->link }}</td>
                                            <td>{{ $episode->numberSeason->number }}</td>
                                            <td>
                                                @if ($episode->status == 1)
                                                    Habilitado
                                                @else
                                                    Deshabilitado
                                                @endif
                                            </td>
                                            <td>
                                                @if ($episode->home == 1)
                                                    SÍ
                                                @else
                                                    NO
                                                @endif
                                            </td>
                                            <td>
                                                <a class="btn btn-info" href="{{ route('episodes.edit', $episode->id) }}">Editar</a>
                                                {!! Form::open(['method' => 'DELETE', 'route' => ['episodes.destroy', $episode->id], 'style' => 'display:inline']) !!}
                                                {!! Form::submit('Eliminar', ['class' => 'btn btn-danger']) !!}
                                                {!! Form::close() !!}
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="pagination justify-content-end">
                                {!! $episodes->links() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

