@extends('layouts.app')

@section('content')
    <section class="section">
        <div class="section-header">
            <h3 class="page__heading">Nuevo Episodio</h3>
        </div>
        <div class="section-body">
            <div class="row">
                <div class="col-lg-12 ">
                    <div class="card">
                        <div class="card-body">

                            @if($errors->any())
                                <div class="alert alert-dark alert-dismissible fade show" role="alert">
                                    <strong>Revise los campos ingresados</strong>
                                    @foreach($errors->all() as $error)
                                        <span class="badge badge-danger">{{ $error }}</span>
                                    @endforeach
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endif

                            {!! Form::open(array('route' => 'episodes.store', 'method' => 'POST')) !!}

                                <div class="form-group">
                                    <label>Título</label>
                                    <input type="text" name="title" required class="form-control">
                                </div>

                                <div class="form-group">
                                    <label>Descripción</label>
                                    <input type="text" name="description" required class="form-control">
                                </div>

                                <div class="form-group">
                                    <label>Link Vimeo</label>
                                    <input type="text" name="link" required class="form-control">
                                </div>

                                <div class="form-group">
                                    <label>Temporada</label>
                                    <select name="season" required class="form-control">
                                        @foreach($seasons as $season)
                                            <option value="{{ $season->id }}">{{ $season->number }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label>Estado</label>
                                    <select name="status" required class="form-control">
                                        <option value="1">Habilitado</option>
                                        <option value="0">Deshabilitado</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="inputFirstname">Mostrar en Home:</label>
                                        <label class="selectgroup-item">
                                            <input type="radio" name="home" value="1" class="selectgroup-input">
                                            <span class="selectgroup-button">SÍ</span>
                                        </label>
                                        <label class="selectgroup-item">
                                            <input type="radio" name="home" value="0" checked class="selectgroup-input">
                                            <span class="selectgroup-button">NO</span>
                                        </label>
                                </div>

                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary">Guardar</button>
                                </div>


                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection




